/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.api.item.IInventoryContainerItem;
import cofh.lib.gui.container.ContainerInventoryItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryContainerItemWrapper
implements IInventory {
    protected final IInventoryContainerItem inventoryItem;
    protected final ItemStack stack;
    protected NBTTagCompound tag;
    protected ItemStack[] inventory;
    protected boolean dirty = false;

    @Deprecated
    public InventoryContainerItemWrapper(ContainerInventoryItem containerInventoryItem, ItemStack itemStack) {
        this(itemStack);
    }

    public InventoryContainerItemWrapper(ItemStack itemStack) {
        this.stack = itemStack;
        this.inventoryItem = (IInventoryContainerItem)this.stack.getItem();
        this.inventory = new ItemStack[this.getSizeInventory()];
        this.loadInventory();
        this.markDirty();
    }

    protected void loadInventory() {
        boolean bl = false;
        if (this.stack.stackTagCompound == null || !this.stack.stackTagCompound.hasKey("Inventory")) {
            bl = this.stack.hasTagCompound();
            if (bl) {
                if (this.stack.stackTagCompound.hasKey("inventory")) {
                    this.tag = this.stack.stackTagCompound.getCompoundTag("inventory");
                    this.stack.stackTagCompound.removeTag("inventory");
                } else {
                    this.tag = this.stack.stackTagCompound;
                }
                this.loadStacks();
                this.tag = new NBTTagCompound();
                this.saveStacks();
            } else {
                this.stack.setTagInfo("Inventory", (NBTBase)new NBTTagCompound());
            }
        }
        this.tag = this.stack.stackTagCompound.getCompoundTag("Inventory");
        this.loadStacks();
    }

    protected void loadStacks() {
        int n = this.inventory.length;
        while (n-- > 0) {
            if (this.tag.hasKey("Slot" + n)) {
                this.inventory[n] = ItemStack.loadItemStackFromNBT((NBTTagCompound)this.tag.getCompoundTag("Slot" + n));
                continue;
            }
            if (this.tag.hasKey("slot" + n)) {
                this.inventory[n] = ItemStack.loadItemStackFromNBT((NBTTagCompound)this.tag.getCompoundTag("slot" + n));
                continue;
            }
            this.inventory[n] = null;
        }
    }

    protected void saveStacks() {
        int n = this.inventory.length;
        while (n-- > 0) {
            if (this.inventory[n] == null) {
                this.tag.removeTag("Slot" + n);
                continue;
            }
            this.tag.setTag("Slot" + n, (NBTBase)this.inventory[n].writeToNBT(new NBTTagCompound()));
        }
        this.stack.setTagInfo("Inventory", (NBTBase)this.tag);
    }

    public void markDirty() {
        this.saveStacks();
        this.dirty = true;
    }

    public boolean getDirty() {
        boolean bl = this.dirty;
        this.dirty = false;
        return bl;
    }

    public Item getContainerItem() {
        return this.stack.getItem();
    }

    public ItemStack getContainerStack() {
        this.saveStacks();
        return this.stack;
    }

    public int getSizeInventory() {
        return this.inventoryItem.getSizeInventory(this.stack);
    }

    public ItemStack getStackInSlot(int n) {
        return this.inventory[n];
    }

    public ItemStack decrStackSize(int n, int n2) {
        ItemStack itemStack = this.inventory[n];
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.splitStack(n2);
        if (itemStack.stackSize <= 0) {
            this.inventory[n] = null;
            itemStack2.stackSize += itemStack.stackSize;
        }
        return itemStack2;
    }

    public void setInventorySlotContents(int n, ItemStack itemStack) {
        this.inventory[n] = itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int n) {
        return null;
    }

    public boolean isItemValidForSlot(int n, ItemStack itemStack) {
        if (itemStack != null && itemStack.getItem() instanceof IInventoryContainerItem) {
            return ((IInventoryContainerItem)itemStack.getItem()).getSizeInventory(itemStack) <= 0;
        }
        return true;
    }

    public String getInventoryName() {
        return this.stack.getDisplayName();
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
        this.markDirty();
    }
}

